$programs = Get-WmiObject Win32_Product
$processes = Get-Process -Name "Java*"
$keeper = 51
$userprofile = $env:userprofile
$log = "$userprofile\AppData\Local\Remove-Java.log"
$date = Get-Date
write-output "Started $date" >$log
if ($processes.Count -gt 0){
write-output "--Killing-Process---------" >>$log
foreach ($myprocess in $processes){
$myprocess.kill()
write-output "Killed $myprocess" >>$log}}
else{}
write-output "--UnInstalling------------" >>$log
foreach ($program in $programs){
if (($program.name -like "*java*")-or($program.name -like "*J2SE*")-and($program.name -notlike "*$keeper*")){
$program.uninstall()
write-output Removed $program.name >>$log}
else{write-output Skipping $program.name >>$log}
}
$date = Get-Date
write-output "Finished $date" >>$log