import-module ActiveDirectory

#create Excel Workbook
$Excel = New-Object -Com Excel.Application 
$Excel.visible = $True 
$Excel = $Excel.Workbooks.Add() 

$wSheet = $Excel.Worksheets.Item(1) 
$wSheet.Cells.item(1,1) = "Groups:" 
$wSheet.Cells.item(1,2) = "SAM:" 
$wSheet.Cells.Item(1,3) = "Users:" 
$wSheet.Cells.Item(1,4) = "Description:"


$WorkBook = $wSheet.UsedRange 
$WorkBook.Interior.ColorIndex = 45 
$WorkBook.Font.ColorIndex = 1 
$WorkBook.Font.Bold = $True 

$groups = get-content input.txt

$intRow = 1
foreach ($group in $groups)
{
$intRow++
$arrMembers = Get-ADGroupMember -Identity $group 
foreach ($member in $arrMembers){
$user = get-aduser -identity $member -Properties *
If ($member.name)
{
$wSheet.Cells.item($intRow,1) = $group
$wSheet.Cells.item($intRow,2) = $user.samaccountname
$wSheet.Cells.Item($intRow,3) = $user.name
$wSheet.Cells.Item($intRow,4) = $user.description
$intRow++
}
Else
{
}
}
}
