import-module ActiveDirectory

#create Excel Workbook
$Excel = New-Object -Com Excel.Application 
$Excel.visible = $True 
$Excel = $Excel.Workbooks.Add() 

$wSheet = $Excel.Worksheets.Item(1) 
$wSheet.Cells.item(1,1) = "Groups:" 
$wSheet.Cells.Item(1,2) = "#Users:" 

$WorkBook = $wSheet.UsedRange 
$WorkBook.Interior.ColorIndex = 45 
$WorkBook.Font.ColorIndex = 1 
$WorkBook.Font.Bold = $True 

$groups = Get-ADGroup Filter * | Select Name

$intRow = 1
$intRow++
foreach ($group in $groups){
If ($group.name) {
if ((Get-ADGroupmember -Identity $group.name).count -ne $Null) {
$count = (Get-ADGroupmember -Identity $group.name).count
}
else {
$count = 0
}
$wSheet.Cells.item($intRow,1) = $group.name
$wSheet.Cells.Item($intRow,2) = $count
$intRow++
}
else {
}
}
