import-module activedirectory

$domain = "5-E.ME" 
$days = 60 
$time = (Get-Date).Adddays(-($days))

Get-ADComputer -Filter {LastLogonTimeStamp -lt $time} -Properties LastLogonTimeStamp,OperatingSystem | 
select-object Name,OperatingSystem,@{Name="Stamp"; Expression={[DateTime]::FromFileTime($_.lastLogonTimestamp)}} | 
export-csv Obsolete-Computer.csv -notypeinformation
