import-module activedirectory

$domain = "5-E.ME" 
$days = 30 
$time = (Get-Date).Adddays(-($days))

Get-ADComputer -Filter {LastLogonTimeStamp -gt $time} -Properties LastLogonTimeStamp,OperatingSystem | 
select-object Name,OperatingSystem,@{Name="Stamp"; Expression={[DateTime]::FromFileTime($_.lastLogonTimestamp)}} | 
export-csv Active-Computer.csv -notypeinformation
