import-module ActiveDirectory

#create Excel Workbook
$Excel = New-Object -Com Excel.Application 
$Excel.visible = $True 
$Excel = $Excel.Workbooks.Add() 

$wSheet = $Excel.Worksheets.Item(1) 
$wSheet.Cells.item(1,1) = "User:" 
$wSheet.Cells.Item(1,2) = "Last Login:" 

$WorkBook = $wSheet.UsedRange 
$WorkBook.Interior.ColorIndex = 45 
$WorkBook.Font.ColorIndex = 1 
$WorkBook.Font.Bold = $True 

$users = Get-content input.txt
$dcs = Get-ADDomainController -Filter {Name -like "*"}
$time = "Never"

$intRow = 1
$intRow++
foreach ($user in $users){
foreach($dc in $dcs){
$hostname = $dc.HostName
$1user = Get-ADUser $user | Get-ADObject -Properties lastLogon 
if($1user.LastLogon -ne $null){
$dt = $1user.LastLogon
$time = [DateTime]::FromFileTime($dt)
}
}

$wSheet.Cells.item($intRow,1) = $user
$wSheet.Cells.Item($intRow,2) = $time
$intRow++
}
