$groups = get-content input.txt

import-module ActiveDirectory

foreach ($group in $groups){
$arrMembers = Get-ADGroupMember -Identity $group
foreach ($member in $arrMembers){
$user = Get-ADUser $member -Properties *
$emailto = $user.mail
$emailname = $user.GivenName
$nousers = "No users in $group"
$sent = "email sent to $emailto about $group"
$emailerror = "email failed for $emailname"
[string]$emailbody = ""
$emailbody = $emailbody + "Hello $emailname, " + "`r`n"
$emailbody = $emailbody + " " + "`r`n"
$emailbody = $emailbody + "I see you are a member of the Active Directory Group ""$group"". " + "`r`n"
$emailbody = $emailbody + " " + "`r`n"
$emailbody = $emailbody + "How cool is that! " + "`r`n" 
$emailbody = $emailbody + " " + "`r`n"
$emailbody = $emailbody + "Admin Team " + "`r`n"
$emailbody = $emailbody + "555-555-5555 Office " + "`r`n"

function sendMail{
Write-Host "Sending Email to $user.mail"
#SMTP server name
$smtpServer = "SMTPserver.Domain.com"
#Creating a Mail object
$msg = new-object Net.Mail.MailMessage
#Creating SMTP server object
$smtp = new-object Net.Mail.SmtpClient($smtpServer)
#Email structure 
$msg.From = "NoReply@Domain.com"
$msg.ReplyTo = "AdminTeam@Domain.com"
$msg.To.add("$emailto")
$msg.subject = "Requesting info about $group"
$msg.body = $emailbody
#Sending email 
$smtp.Send($msg)
}
If (($user.mail) -ne $Null) {
Try {sendMail
$sent >> info.tmp} 
catch {$emailerror >> info.tmp}
}
ELSE {
$nousers >> info.tmp
}
}
}
