Import-Module ActiveDirectory

$names = Get-Content input.txt
$add = "Reason to disable user"

#Process users.
Foreach ($name in $names) {

$users = get-aduser -Identity "$name"

#Process users.
Foreach ($user in $users) {

$user >>OldName.log

Try {Disable-ADAccount -Identity "$user"}
Catch {Write-output "Unable to Disable $user" >>Error.txt}

$newname = $user.surname + ", " + $user.GivenName + " ($add)"
Try {Rename-ADObject -identity "$user" -Newname "$newname" -server 5-E.ME}
Catch {Write-output "Unable to change DN for $user to $newname" >>ERROR.txt"}
}
}
